<refentry id="{@id}">
 <refnamediv>
  <refname>Writing a New Converter</refname>
  <refpurpose>Overview of how to write a new Converter</refpurpose>
 </refnamediv>
 <refsynopsisdiv>
  <authorgroup>
   <author>
    Joshua Eichorn
    <authorblurb>
     {@link mailto:jeichorn@phpdoc.org jeichorn@phpdoc.org}
    </authorblurb>
   </author>
   <author>
    Gregory Beaver
    <authorblurb>
     {@link mailto:cellog@sourceforge.com cellog@sourceforge.com}
    </authorblurb>
   </author>
  </authorgroup>
 </refsynopsisdiv>
 <refsect1 id="{@id intro}">
  <title>Introduction to Converters</title>
  <para>This documentation deals only with the advanced programming topic of creating a new output converter.  To learn how to use phpDocumentor, read the {@tutorial phpDocumentor/phpDocumentor.pkg}.  To learn how to extend an existing Converter, read {@tutorial Converters/Converters.pkg}</para>
 </refsect1>
 <refsect1 id="{@id concepts}">
  <title>Basic Concepts</title>
  <refsect2 id="{@id abstractdata}">
   <title>Abstract Parsing Data</title>
   <refsect3 id="{@id source}">
    <title>Source Code Elements</title>
    <para>A Converter's job is to take abstract data from parsing and create documentation.  What is the abstract data?  phpDocumentor is capable of documenting tutorials, and a php file and its re-usable or structurally important contents.  In other words, phpDocumentor can document:
     <itemizedlist>
      <listitem>A XML DocBook-based tutorial (see {@tutorial phpDocumentor/tutorials.pkg})</listitem>
      <listitem>Procedural Page (PHP source file)</listitem>
      <listitem>Include Statements</listitem>
      <listitem>Define Statements</listitem>
      <listitem>Global Variables</listitem>
      <listitem>Functions</listitem>
      <listitem>Classes</listitem>
      <listitem>Class Variables</listitem>
      <listitem>Class Methods</listitem>
     </itemizedlist>
    </para>
    <para>phpDocumentor represents these PHP elements using classes:
     <itemizedlist>
      <listitem>{@link parserTutorial}</listitem>
      <listitem>{@link parserData, parserPage}</listitem>
      <listitem>{@link parserInclude}</listitem>
      <listitem>{@link parserDefine}</listitem>
      <listitem>{@link parserGlobal}</listitem>
      <listitem>{@link parserFunction}</listitem>
      <listitem>{@link parserClass}</listitem>
      <listitem>{@link parserVar}</listitem>
      <listitem>{@link parserMethod}</listitem>
     </itemizedlist>
    </para>
    <para>This relationship between the source code and abstract data is quite clear, and very simple.  The data members of each abstract representation correspond with the information needed to display the documentation. All PHP elements contain a DocBlock, and this is represented by a class as well, {@link parserDocBlock}.  The elements of a DocBlock are simple:
     <itemizedlist>
      <listitem>Short Description, containing any number of inline tags</listitem>
      <listitem>Long Description, containing any number of inline tags</listitem>
      <listitem>Tags, some containing any number of inline tags in their general description field</listitem>
     </itemizedlist>
    </para>
    <para>phpDocumentor represents these elements using classes as well:
     <itemizedlist>
      <listitem>{@link parserDesc} for both short and long descriptions</listitem>
      <listitem>{@link parserInlineTag} for inline tags</listitem>
      <listitem>{@link parserTag} for regular tags</listitem>
     </itemizedlist>
    </para>
   </refsect3>
   <refsect3 id="{@id html}">
    <title>HTML-specific issues</title>
    <para>There are some other issues that Converters solve.  In HTML, a link is represented by an &lt;a&gt; tag, but in the PDF Converter, it is represented by a &lt;c:ilink&gt; tag.  How can we handle both cases?  Through another abstract class, the {@link abstractLink} and its descendants:
     <itemizedlist>
      <listitem>{@link tutorialLink}</listitem>
      <listitem>{@link pageLink}</listitem>
      <listitem>{@link defineLink}</listitem>
      <listitem>{@link globalLink}</listitem>
      <listitem>{@link functionLink}</listitem>
      <listitem>{@link classLink}</listitem>
      <listitem>{@link varLink}</listitem>
      <listitem>{@link methodLink}</listitem>
     </itemizedlist>
     Note the absence of an &quot;includeLink&quot; class - this is intentional, as only re-usable elements need to be linked.  An include statement is always attached to the file that it is in, and cannot be anywhere else.
    </para>
    <para>These abstract linking classes contain the information necessary to differentiate between the location of any of the element's documentation.  They are only used to allow linking to documentation, and not to source code.  A link is then converted to the appropriate text representation for the output format by {@link Converter::returnSee()} (a href=link for html, c:ilink:link for pdf, link linkend=link in xml:docbook, and so on).</para>
    <para>The other issues solved by a converter involves html in a DocBlock.  To allow better documentation, html is allowed in DocBlocks to format the output.  Unfortunately, this complicates output in other formats.  To solve this issue, phpDocumentor also parses out all allowed HTML (see {@tutorial phpDocumentor.howto.pkg#basics.desc} for more detailed information) into abstract structures:
     <itemizedlist>
      <listitem>&lt;b&gt; -- emphasize/bold text</listitem>
      <listitem>&lt;br&gt; -- hard line break, may be ignored by some converters</listitem>
      <listitem>&lt;code&gt; -- Use this to surround php code, some converters will highlight it</listitem>
      <listitem>&lt;i&gt; -- italicize/mark as important</listitem>
      <listitem>&lt;li&gt; -- list item</listitem>
      <listitem>&lt;ol&gt; -- ordered list</listitem>
      <listitem>&lt;p&gt; -- If used to enclose all paragraphs, otherwise it will be considered text</listitem>
      <listitem>&lt;pre&gt; -- Preserve line breaks and spacing, and assume all tags are text (like XML's CDATA)</listitem>
      <listitem>&lt;ul&gt; -- unordered list</listitem>
     </itemizedlist>
     is mapped to classes:
     <itemizedlist>
      <listitem>{@link parserB}</listitem>
      <listitem>{@link parserBr}</listitem>
      <listitem>{@link parserCode}</listitem>
      <listitem>{@link parserI}</listitem>
      <listitem>{@link parserList} - both types of lists are represented by this object, and each &lt;li&gt; is represented by an array item</listitem>
      <listitem>{@link parserPre}</listitem>
     </itemizedlist>
     &lt;p&gt; is represented by partitioning text into an array, where each array item is a new paragraph. (as in {@link parserDocBlock::$processed_desc})
    </para>
    <para>With these simple structures and a few methods to handle them, the process of writing a new converter is straightforward.</para>
   </refsect3>
   <refsect3 id="{@id output}">
    <title>Separation of data from display formatting</title>
    <para>phpDocumentor has been designed to keep as much formatting out of the source code as possible.  For many converters, there need be no new code written to support the conversion, as all output-specific information can be placed in template files.  However, the complexity of generating class trees does require the insertion of some code into the source, so at the bare minimum, the {@tutorial Converter.methods.cls#override.getroottree} method must be overridden.</para>
   </refsect3>
  </refsect2>
 </refsect1>
 <refsect1 id="{@id override}">
  <title>Methods that must be overridden</title>
  <para>Creating a new converter can be challenging, but should not be too complicated.  You need to override one data structure, {@link Converter::$leftindex}, to tell the Converter which of the individual element indexes your Converter will use.  You will also need to override a few methods for the Converter to work.  The most important relate to linking and output.</para>
  <para>A Converter must override these core methods:
   <itemizedlist>
    <listitem>{@tutorial Converter.methods.cls#core.convert} - take any descendant of parserElement or a parserPackagePage and convert it into output</listitem>
    <listitem>{@tutorial Converter.methods.cls#core.returnsee} - takes a abstract link and returns a string that links to an element's documentation</listitem>
    <listitem>{@tutorial Converter.methods.cls#core.returnlink} - takes a URL and text to display and returns an internet-enabled link</listitem>
    <listitem>{@tutorial Converter.methods.cls#core.output} - generate output, or perform other cleanup activities</listitem>
    <listitem>{@tutorial Converter.methods.cls#core.convert-ric} - Converts README/INSTALL/CHANGELOG file contents for inclusion in documentation</listitem>
    <listitem>{@tutorial Converter.methods.cls#core.converterrorlog} - formats errors and warnings from {@link $phpDocumentor_errors}. see {@link HTMLframesConverter::ConvertErrorLog()}</listitem>
    <listitem>{@tutorial Converter.methods.cls#core.getfunctionlink} - for all of the functions below, see {@link HTMLframesConverter::getFunctionLink()} for an example </listitem>
    <listitem>{@tutorial Converter.methods.cls#core.getclasslink}</listitem>
    <listitem>{@tutorial Converter.methods.cls#core.getdefinelink}</listitem>
    <listitem>{@tutorial Converter.methods.cls#core.getgloballink}</listitem>
    <listitem>{@tutorial Converter.methods.cls#core.getmethodlink}</listitem>
    <listitem>{@tutorial Converter.methods.cls#core.getvarlink}</listitem>
   </itemizedlist>
  </para>
  <para>A Converter may optionally implement these abstract methods:
   <itemizedlist>
    <listitem>{@tutorial Converter.methods.cls#override.endpage} - do any post-processing of procedural page elements, possibly output documentation for the page</listitem>
    <listitem>{@tutorial Converter.methods.cls#override.endclass} - do any post-processing of class elements, possibly output documentation for the class</listitem>
    <listitem>{@tutorial Converter.methods.cls#override.formatindex} - format the {@link $elements} array into an index see {@link HTMLframesConverter::generateElementIndex()}</listitem>
    <listitem>{@tutorial Converter.methods.cls#override.formatpkgindex} - format the {@link $pkg_elements} array into an index see {@link HTMLframesConverter::generatePkgElementIndex()}</listitem>
    <listitem>{@tutorial Converter.methods.cls#override.formatleftindex} - format the {@link $elements} array into an index see {@link HTMLframesConverter::formatLeftIndex()}</listitem>
    <listitem>{@tutorial Converter.methods.cls#override.formattutorialtoc} - format the output of a {@}toc} tag, see {@link HTMLframesConverter::formatTutorialTOC()}</listitem>
    <listitem>{@tutorial Converter.methods.cls#override.getroottree} - generates an output-specific tree of class inheritance</listitem>
    <listitem>{@tutorial Converter.methods.cls#override.smartyinit} - initialize a {@link Smarty} template object</listitem>
    <listitem>{@tutorial Converter.methods.cls#override.writesource} - write out highlighted source code for a parsed file</listitem>
    <listitem>{@tutorial Converter.methods.cls#override.writeexample} - write out highlighted source code for an example</listitem>
    <listitem>{@tutorial Converter.methods.cls#override.unmangle} - do any post-processing of class elements, possibly output documentation for the class</listitem>
   </itemizedlist>
  </para>
  <para>The following methods may need to be overridden for proper functionality, and are for advanced situations.
   <itemizedlist>
    <listitem>{@tutorial Converter.methods.cls#advanced.checkstate} - used by the {@link parserStringWithInlineTags::Convert()} cache to determine whether a cache hit or miss occurs</listitem>
    <listitem>{@tutorial Converter.methods.cls#advanced.getstate} - used by the {@link parserStringWithInlineTags::Convert()} cache to save state for the next Convert() call</listitem>
    <listitem>{@tutorial Converter.methods.cls#advanced.type-adjust} - used to enclose type names in proper tags as in {@link XMLDocBookConverter::type_adjust()}</listitem>
    <listitem>{@tutorial Converter.methods.cls#advanced.postprocess} - called on all converted text, so that any illegal characters may be escaped.  The HTML Converters, for example,  pass all output through {@link htmlentities()}</listitem>
    <listitem>{@tutorial Converter.methods.cls#advanced.gettutorialid} - called by the {@}id} inline tag to get the Converter's way of representing a document anchor</listitem>
   </itemizedlist>
  </para>
 </refsect1>
 <refsect1 id="{@id utility}">
  <title>Converter methods an extended converter should use</title>
  <para>
   <itemizedlist>
    <listitem>{@tutorial Converter.methods.cls#utility.getsortedclasstreefromclass} -- generating class trees by package</listitem>
    <listitem>{@tutorial Converter.methods.cls#utility.hastutorial} -- use this to retrieve a tutorial, or determine if it exists</listitem>
    <listitem>{@tutorial Converter.methods.cls#utility.gettutorialtree} -- use this to retrieve a hierarchical tree of tutorials that can be used to generate a table of contents for all tutorials</listitem>
    <listitem>{@tutorial Converter.methods.cls#utility.vardump-tree} -- use this to assist in debugging large tree structures of tutorials</listitem>
   </itemizedlist>
  </para>
 </refsect1>
</refentry>