<?php
//
// +------------------------------------------------------------------------+
// | phpDocumentor                                                          |
// +------------------------------------------------------------------------+
// | Copyright (c) 2000-2003 Joshua Eichorn, Gregory Beaver                 |
// | Email         jeichorn@phpdoc.org, cellog@phpdoc.org                   |
// | Web           http://www.phpdoc.org                                    |
// | Mirror        http://phpdocu.sourceforge.net/                          |
// | PEAR          http://pear.php.net/package-info.php?pacid=137           |
// +------------------------------------------------------------------------+
// | This source file is subject to version 3.00 of the PHP License,        |
// | that is available at http://www.php.net/license/3_0.txt.               |
// | If you did not receive a copy of the PHP license and are unable to     |
// | obtain it through the world-wide-web, please send a note to            |
// | license@php.net so we can mail you a copy immediately.                 |
// +------------------------------------------------------------------------+
//
/**
 * PEAR Package.xml file generator
 *
 * NOTE: This uses phpDocumentor 1.2.0 docblock templates, and will not parse
 * properly with phpDocumentor 1.1.0
 * @package PEAR
 * @author Greg Beaver <cellog@users.sourceforge.net>
 * @copyright Copyright 2002, Greg Beaver
 * @version 1.0
 */
/**#@+
 * phpDocumentor include files.  If you don't have phpDocumentor, go get it!
 * Your php life will be changed forever
 */
require_once("../phpDocumentor/common.inc.php");
require_once("../phpDocumentor/Io.inc");
/**#@-*/

/**
 * @global string $version
 */
$version = "1.2.0";
/**
 * @global string $state
 */
$state = "stable";
/**
 * @global string $date
 */
$date = date('Y-m-d');
/**
 * Dependencies of this.  Structure is
 * <pre>
 * array(
 *   array('type' => 'php' or 'pkg',
 *         'rel' => any comparison operator, or 'eq','lt','ge','le',etc.
 *       [ 'version' => php version if type = php ]
 *        )
 *      )
 * </pre>
 * @global array $deps
 */
$deps = array(
          array('type' => 'php',
                'rel' => 'ge',
                'version' => '4.1.0')
             );
/**
 * @global string $notes
 */
$notes = <<< EOF
The first stable release through PEAR of phpDocumentor

Features:
- New tokenizer-based parser is literally twice
  as fast as the old parser (requires PHP 4.3.0+)
- New external user-level manual parsing and generation
  allows cross-linking between API docs and DocBook-format tutorials/manuals!
- Highlight Parsing and cross-referencing with documentation
  of source code in HTML, and PDF with customizable templating
- New Configuration files simplify repetitive and complex documentation tasks
- Brand new extensive manual - which can be generated directly
  from the source using makedocs.ini!
- Many improvements to in-code API documentation including new
  tags, and better handling of in-code html tags
- CHM and PDF converters are both beta quality
- New XML:DocBook/peardoc converter makes generating PEAR
  manual formats easy for PEAR developers along with the --pear command-line switch
- Many new HTML templates, all of them beautiful thanks to Marco von Ballmoos
- A brand new web interface thanks to Andrew Eddie!

***********************************************************************
phpDocumentor != PHPDoc
Do not use "pear install PHPDoc" if you want phpDocumentor, use
"pear install PhpDocumentor" the two tools are completely separate.
***********************************************************************

for PEAR users, the new --pear command-line switch will be a boon.  Leave it on
by default if your package follows PEAR coding and directory naming standards

The peardoc2 converter has been moved to an extension of the DocBook converter,
to use, the command-line has changed from XML:DocBook:peardoc2 to
XML:DocBook/peardoc2:default.

We have removed the HTML:default converter entirely, use HTML:frames.  This
will fix the last of the persistent windows installation bugs.

EOF;

/**
* Physical location on this computer of the package to parse
* @global string $package_directory
*/
$package_directory = 'C:/Web Pages/chiara/phpdoc';
/**
* PEAR-relative install dir, used as attribute for <dir name="/">
* @global string $baseinstalldir
*/
$baseinstalldir = 'PhpDocumentor';
/**
* Comma-separated list of files and directories to ignore
*
* This uses wildcards * and ? to remove extra files/directories that are
* not part of the package or release
* @global string $ignore
*/
$ignore = array('CVS/','package.xml','*.tgz','test.php','.*','*.apf','greg.ini','Beautifier*','xhtmlcss/','pear.php','utilities.php','utilities.inc','test.php','test/','*HTML/default*');
/**
* Mapping of file extensions to the role attribute of the <file> tag
*
* '*' is the default role for files with no extension or extensions not shown
* @global array $roles
*/
$roles = array
			(
				'php' => 'php',
				'inc' => 'php',
				'html' => 'doc',
				'*' => 'php',
			);
			
/**
* Mapping of subdirectory names to the role attribute of the <dir> tag
* @global array $dir_roles
*/
$dir_roles = array
				(
					'spec' => 'doc',
					'tests' => 'test',
					'Release-old' => 'doc',
					'user' => 'php',
					'templates' => 'php',
                    'templates_c' => 'php',
				);
			
/**
* Mapping of filenames to roles for files that don't fit the normal
* {@link $roles}
* @global array $exceptions
*/
$exceptions = array
				(
                    'Authors'   => 'doc',
                    'COPYING'   => 'doc',
                    'index.html' => 'php',
                    'INSTALL' => 'doc',
					'README' => 'doc',
                    'FAQ' => 'doc',
					'ChangeLog' => 'doc',
					'makedoc.sh' => 'php',
                    'phpdoc' => 'script',
					'Release-1.2.0' => 'doc',
					'Release-1.1.0' => 'doc',
					'Release-1.1.0rc1' => 'doc',
					'Release-1.1.0rc2' => 'doc',
                    'Release-1.2.0beta1' => 'doc',
                    'Release-1.2.0beta2' => 'doc',
                    'Release-1.2.0beta3' => 'doc',
                    'Release-1.2.0rc1' => 'doc',
                    'Release-1.2.0rc2' => 'doc',
				);

/******************************************************************************
*       Don't change anything below here unless you're adventuresome          *
*******************************************************************************/

/**
 * Determines whether output is made html-friendly or not
 * @global boolean $webinterface
 */
$webinterface = isset($_SERVER['PATH_TRANSLATED']);
/**
 * @global Io $files
 */
$files = new Io;

$allfiles = $files->dirList($package_directory);
/**#@+
 * Sorting functions for the file list
 * @param string
 * @param string
 */
function sortfiles($a, $b)
{
	return strnatcasecmp($a['file'],$b['file']);
}

function mystrucsort($a, $b)
{
	if (is_numeric($a) && is_string($b)) return 1;
	if (is_numeric($b) && is_string($a)) return -1;
	if (is_numeric($a) && is_numeric($b))
	{
		if ($a > $b) return 1;
		if ($a < $b) return -1;
		if ($a == $b) return 0;
	}
	return strnatcasecmp($a,$b);
}
/**#@-*/

$struc = array();
foreach($allfiles as $file)
{
	if ($files->checkIgnore(basename($file),dirname($file),$ignore, false))
    {
//        print 'Ignoring '.$file."<br>\n";
        continue;
    }
	$path = substr(dirname($file),strlen(str_replace('\\','/',realpath($package_directory)))+1);
	if (!$path) $path = '/';
	$file = basename($file);
	$ext = array_pop(explode('.',$file));
	if (strlen($ext) == strlen($file)) $ext = '';
	$struc[$path][] = array('file' => $file,'ext' => $ext);
}
uksort($struc,'strnatcasecmp');
foreach($struc as $key => $ind)
{
	usort($ind,'sortfiles');
	$struc[$key] = $ind;
}
$tempstruc = $struc;
$struc = array('/' => $tempstruc['/']);
$bv = 0;
foreach($tempstruc as $key => $ind)
{
	$save = $key;
	if ($key != '/')
	{
        $struc['/'] = setup_dirs($struc['/'], explode('/',$key), $tempstruc[$key]);
	}
}
uksort($struc['/'],'mystrucsort');
/**
 * Recursively generate the <filelist> section's <dir> and <file> tags
 * @param array the sorted directory structure
 * @param false|string whether the parent directory has a role this should
 * inherit
 * @param integer indentation level
 * @global array directory roles
 * @global array exceptions to standard file roles
 * @global array standard file roles
 * @global string base installation directory
 */
function getDirTag($struc, $role=false, $level = 0)
{
	global $dir_roles, $exceptions, $roles, $baseinstalldir;
	$res = $spaces = '';
	for($i= -4; $i < $level; $i++)
	{
		$spaces .= ' ';
	}
	foreach($struc as $dir => $files)
	{
		if ($dir === '/')
		{
			$my = '   <dir name="/" baseinstalldir="'.$baseinstalldir.'">'."\n";
			$my .= getDirTag($struc[$dir], $role, $level + 1);
			$my .= '   </dir>';
			return $my;
		} else
		{
			if (!isset($files['file']))
			{
				$myrole = '';
				if ($role) $myrole = $role;
				elseif (isset($dir_roles[$dir])) $myrole = ' role="'.$dir_roles[$dir].'"';
				$res .= $spaces.'<dir name="'.$dir.'"'.$myrole.">\n";
				$res .= getDirTag($files,$myrole,$level + 1);
				$res .= $spaces.'</dir>'."\n";
			} else
			{
				$myrole = '';
				if (!$role)
				{
					$myrole = false;
					if (isset($exceptions[$files['file']]))
					{
						$myrole = $exceptions[$files['file']];
					} elseif (isset($roles[$files['ext']]))
					{
						$myrole = $roles[$files['ext']];
					} else $myrole = $roles['*'];
					$myrole = ' role="'.$myrole.'"';
				}
				
				$res .= $spaces.'<file'.$myrole.'>'.$files['file'].'</file>'."\n";
			}
		}
	}
	return $res;
}

/**
 * Translate the dependencies array into XML
 * @param array dependencies of this package
 * @return string XML-ized dependencies
 */
function processDependencies($deps)
{
    $dependencies = '';
    foreach($deps as $dep)
    {
        $dependencies .= '   <dep type="'.$dep['type'].'" rel="'.$dep['rel'].'"';
        if ($dep['type'] == 'php')
        {
            $dependencies .= ' version="'.$dep['version'].'" />'."\n";
        }
    }
    return $dependencies;
}
$notes = htmlspecialchars($notes);
$res = getDirTag($struc);
$deps = processDependencies($deps);
$res = 
" <release>
  <version>$version</version>
  <state>$state</state>
  <date>$date</date>
  <notes>
$notes
  </notes>
  <filelist>
$res
  </filelist>
  <deps>
$deps
  </deps>
 </release>
";
if ($webinterface)
print nl2br(str_replace(' ','&nbsp;',htmlentities($res)));
else
print $res;
?>