#!/usr/bin/perl5

# edit.cgi
# written by Leif M. Wright
# leif@conservatives.net
# http://www.conservatives.net/atheist/scripts/
##########################################################
################# ABOUT THIS SCRIPT ######################
#
# This, as most of my scripts, was written to fill
# an emergency hole in a web site. One of the sites
# I webmaster needed a way to edit files on the fly.
# Since the site was hosted on one of my servers and
# I didn't want to give them the FTP password, (my server
# doesn't allow anonymous FTP logins), I wrote this pair
# of scripts, uploaded them to a password-protected
# directory (via an .htaccess file), and we were in business.
# 
# This file is designed to work in conjunction with
# another script, page.cgi (which actually does
# most of the work). It's VERY bare-bones, and probably
# shouldn't be used by anyone who doesn't know how to 
# write HTML without a WYSIWYG editor. 
# 
################ LET'S GET TO IT ALREADY #################
##########################################################

############### CONFIGURATION STUFF ######################
## basedir is the base directory where the web
## files you want to edit are stored.
## It should be a real directory, not web
## stuff
$basedir   = "/usr/home/leif/public_html/conservatives/atheist/scripts/edit/";

# script_location is the web address for page.cgi
$script_location = "http://www.conservatives.net/atheist/scripts/edit/page.cgi";


################################################
################################################

&parse;

# This is a little bit of PERL shorthand that assigns
# a value to the form input field "name"

$name=$contents{'name'};


&grab_it;
&show_me;



# This is the parse routine, which interprets
# information from the POST method of an HTML form.

sub parse {
    
if ($ENV{'REQUEST_METHOD'} eq 'POST')
{
	read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
	@pairs = split(/&/, $buffer);
	foreach $pair (@pairs)
	{
		($name, $value) = split(/=/, $pair);
		$value =~ tr/+/ /;
		$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		$contents{$name} = $value;
	     
	}
}

}



sub grab_it {
    
open (PAGE, "$basedir$name");
@page=<PAGE>;
close PAGE;
}

# This shoots the results of the script to your screen,
# giving you a chance to edit the web content.

sub show_me {
    
print "Content-Type: text/html\n\n\n";
print "<body bgcolor=#F0F0F0 text=#323232>\n";
print "<font face=Verdana size=2><center>\n";
print "<p>Here's the text of your page, $name:</p>\n";
print "<form action=$script_location method=POST>\n";
print "<input type=hidden name=name value=$name>\n";
print " <textarea name=junk COLS=100 ROWS=20>@page</textarea>\n";
print " <p>\n";
print "<input type=submit>\n";
print "</form>\n";


exit;
}