#!/usr/bin/perl
use DB_File;
use Fcntl;
#------------------------------->
#------------------------------->
sub OpenDB {
#------------------------------->
# This opens the database.
#-------------------------------<
	tie (%db, 'DB_File', $_[0], O_RDWR|O_CREAT, 0777) or &oops("Could not open database $_[0].  $!.  Please notify the system administrator immediately!");
}
#------------------------------->
sub CloseDB {
#------------------------------->
# This closes the database.  
#-------------------------------<
	untie %db;
}

#-#############################################
# Sub: Read Category (cat)
# Reads a category database file

sub read_category {

	my ($cat) = shift;
	&OpenDB("$config{'basepath'}$config{'opendir'}$cat/open.items");
		my %catreturn = %db;
	&CloseDB;
	return %catreturn;


}

#-#############################################
# Sub: Read Closed Category (cat)
# Reads a closed category database file

sub read_closed_category {

	my ($cat) = shift;
	&OpenDB("$config{'basepath'}$config{'closedir'}$cat/closed.items");
		my %catreturn = %db;
	&CloseDB;
	return %catreturn;


}


sub get_cat_stats {
		my $cat = shift;
		&OpenDB("$cat/open.items");
			my $numitems = scalar keys %db;
		&CloseDB;
		return $numitems;
}

#-#############################################
# Sub: Read Item  (item)
# Reads an item

sub read_item {
	my ($item) = shift;
		return 0 if (! $item);
		my ($title, $reserve, $inc, $desc, $image, $bids) = split(/:::/,$item);
	&CloseDB;
	return ($title, $reserve, $inc, $desc, $image, $bids);
}


#-#############################################
# Sub: Read Item File (cat, item)
# Reads an item file

sub read_item_file {
	my ($cat, $item) = @_;
	&OpenDB("$config{'basepath'}$config{'opendir'}$cat/open.items");
		if (!($db{$item})) {
			&CloseDB;
			&OpenDB("$config{'basepath'}$config{'closedir'}$cat/closed.items");
			if (!($db{$item})) {
			&oops("Item number $item in category $category does not exist...  Please check the item and try again!");	
			}
		}
		my ($title, $reserve, $inc, $desc, $image, $bids) = split(/:::/,$db{$item});
	&CloseDB;
	my @bids = split(/}}}/,$bids);
	return ($title, $reserve, $inc, $desc, $image, @bids);
}
#-#############################################
# Sub: Read Bid Information (bid_string)
# Reads an item file

sub read_bid {
	my $bid_string = shift;
	my ($alias, $email, $bid, $time, $add1, $add2, $add3) = split(/\|\|\|/,$bid_string);
	return ($alias, $email, $bid, $time, $add1, $add2, $add3);
}

#-#############################################
# Sub: Split Bid Information (bids)
# Reads a bid string and returns an array of bids

sub get_bids {
	my $bids = shift;
	my @bids  = split(/\}\}\}/,$bids);
	return @bids;
}

#-#############################################
# Sub: Read Reg File (alias)
# Reads a registration file

sub read_reg_file {
	my $alias = shift;
	$alias = ucfirst(lc($alias));
	&oops('Your alias may not contain any non-word characters.') if $alias =~ /\W/;
	&OpenDB("$config{'basepath'}$config{'regdir'}$config{'regdata'}");
	my ($password,$email,$add1,$add2,$add3,@past_bids) = split(/:::/,$db{$alias});
	&CloseDB;
	return ($password,$email,$add1,$add2,$add3,@past_bids);
}

#-#############################################
# Sub: Process Bid
# Process bid on an item

sub procbid {
	my $time = time;
	my $thisbid = "$form{'ALIAS'}|||$form{'EMAIL'}|||$form{'BID'}|||$time|||$form{'ADDRESS1'}|||$form{'ADDRESS2'}|||$form{'ADDRESS3'}";
	my $newbids = $thisbid . "}}}" ;
	&OpenDB("$config{'basepath'}$config{'opendir'}$form{'CATEGORY'}/open.items");
		$db{$form{'ITEM'}} .= $newbids;
	&CloseDB;
	print "<B>$form{'ALIAS'}, your bid has been placed on item number $form{'ITEM'} for \$$form{'BID'} on ".scalar(localtime(time)).".</B><BR>You may want to print this notice as confirmation of your bid.<P>Go <A HREF=\"$ENV{'SCRIPT_NAME'}\?category=$form{'CATEGORY'}\&item=$form{'ITEM'}\">back to the item</A>\n";
}

#-#############################################
# Sub: Post Item
# Post an item

sub postitem {
	my $item_num = shift;
	$form{'BID'} = &parsebid($form{'BID'});
	my $time = time;
	my $bids = "$form{'ALIAS'}\|\|\|$form{'EMAIL'}\|\|\|$form{'BID'}\|\|\|$time\|\|\|$form{'ADDRESS1'}\|\|\|$form{'ADDRESS2'}\|\|\|$form{'ADDRESS3'}";
	$bids .= "}}}";
	umask(000);  # UNIX file permission junk
	mkdir("$config{'basepath'}$config{'opendir'}$form{'CATEGORY'}", 0777) unless (-d "$config{'basepath'}$config{'opendir'}$form{'CATEGORY'}");		
	&OpenDB("$config{'basepath'}$config{'opendir'}$form{'CATEGORY'}/open.items");
		$item_num++ while $db{$item_num};
		$db{$item_num} = join(":::",$form{'TITLE'},$form{'RESERVE'},$form{'INC'},$form{'DESC'},$form{'IMAGE'},$bids);
	&CloseDB;
	print "<H3>$item_num was posted under $category{$form{'CATEGORY'}}...</H3>\n";
}

#-#############################################
# Sub: Proc Reg
# Processs a registration

sub procreg {
		umask(000);  # UNIX file permission junk
		mkdir("$config{'basepath'}", 0777) unless (-d "$config{'basepath'}");		
		mkdir("$config{'basepath'}$config{'regdir'}", 0777) unless (-d "$config{'basepath'}$config{'regdir'}");		
		&OpenDB("$config{'basepath'}$config{'regdir'}$config{'regdata'}");
		my $auctions eq "";
		if (! defined $db{$form{'ALIAS'}}) {
			my $pass = &randompass;
			$db{$form{'ALIAS'}} = $pass . ":::$form{'EMAIL'}:::$form{'ADDRESS1'}:::$form{'ADDRESS2'}:::$form{'ADDRESS3'}:::$auctions";
			require "sendemail.pl";
			print "$form{'ALIAS'}, you should receive an e-mail to $form{'EMAIL'} in a few minutes.  It will contain your password needed to post or bid.  You may change your password once you receive it.  If you do not get an e-mail, please re-register.\n";
			&sendemail($form{'EMAIL'}, $config{'admin_address'}, 'Auction Password', "PLEASE DO NOT REPLY TO THIS E-MAIL.\n\nThank you for registering to use the online auctions at $config{'sitename'}!\n\nYour new password is: $pass\nYour alias (as you entered it) is: $form{'ALIAS'}\n\nThank you for visiting!");
		&CloseDB;
		}
		else {
			print "Sorry...  that alias is taken.  Hit back to try again!\n";
		}
}
#-#############################################
# Sub: Proc Change Reg
# Processs a registration change

sub proccreg {

			&OpenDB("$config{'basepath'}$config{'regdir'}$config{'regdata'}");
			$db{$form{'ALIAS'}} = join(":::",$form{'NEWPASS1'},$form{'EMAIL'},$form{'ADDRESS1'},$form{'ADDRESS2'},$form{'ADDRESS3'},@past_bids);
			&CloseDB;
&read_reg_file($form{'ALIAS'});
}
#------------------------------->
sub CloseItem {
#------------------------------->
# Moves an item from the "open database" to the "closed database".
#-------------------------------<
	&OpenDB("$config{'basepath'}$config{'opendir'}$_[0]/open.items");
	my $temp=$db{$_[1]};
	delete $db{$_[1]};
	&CloseDB;
	&OpenDB("$config{'basepath'}$config{'closedir'}$_[0]/closed.items");
	$db{$_[1]} = $temp;
	&CloseDB;
}

1;