#use strict;
#
require "/home/openauctiondb/pl/config.pl";
require "/home/openauctiondb/pl/BDB.pl";
require "/home/openauctiondb/pl/sendemail.pl";
#
# License: This code is released under the terms of the GNU GPL
# version 2 or later. Please refer to www.gnu.org for a copy
# of this license.
#
##############################################
# Automate Close Auctions
# This allows crond to close all items that
# have passed their closing time.
#
my ($item);
my $repost = "no";
foreach $key (sort keys %category) {
	my %allfiles = &read_category($key); 
foreach $item (sort keys %allfiles) {
if (time > $item) {
		my ($title, $reserve, $inc, $desc, $image, @bids) = &read_item_file($key,$item);
#print "Delete    $title, $reserve, $inc, $desc, $image, @bids\n\n";
		my @firstbid = &read_bid("$bids[0]");
		my @lastbid = &read_bid("$bids[$#bids]");
		my $nowtime = localtime(time);
		my $closetime = localtime($item);
$doit =0; # Set to 0 initially 
if (($lastbid[2] < $reserve) && ($reserve > 0) && ($firstbid[0] ne $lastbid[0]) && ($repost eq 'yes')) {
	$doit = 1;
	$new = ($repostdays * 86400 + time);
	$new++ while $db{$new};
	$db{$new} = $db{$item};
	delete $db{$item};
}

if (($firstbid[0] eq $lastbid[0]) && ($repost eq 'yes')) {
	$doit = 1;
	$new = ($repostdays * 86400 + time);
	$new++ while $db{$new};
	$db{$new} = $db{$item};
	delete $db{$item};
} 

####################################################
########## Define Messages

$BidderReserveMet = "
Congratulations $lastbid[1]!  

You are the winner of this auction:

Item number : $item
Title : $title
Category : $category{$key}
URL Here : http://$config{'scripturl'}/cgi-bin/openauction.cgi\?category=$key&item=$item

Your winning bid was \$$lastbid[2].

Please contact the seller to make arrangements for payment and shipping:

$firstbid[4]
$firstbid[5]
$firstbid[6]
$firstbid[7]
$firstbid[1]

If you are asked to send payment to another person or location
consider the auction null and void. Report this breach of
security to us at once!

Once again, thank you and please tell a friend about us!
Sincerely, $config{'sitename'}
";

$BidderReserveNotMet = "
Congratulations $lastbid[1]!  

You were the high bidder on this auction: 

Item number : $item
Title : $title
Category : $category{$key}
URL Here : http://$config{'scripturl'}/cgi-bin/openauction.cgi\?category=$key&item=$item

Your bid was \$$lastbid[2].

Unfortunately, your bid did not meet the seller\'s reserve price...

You may still wish to contact the seller to negotiate a fair price:

$firstbid[4]
$firstbid[5]
$firstbid[6]
$firstbid[7]
$firstbid[1]

If you are asked to send payment to another person or location
consider the auction null and void. Report this breach of
security to us at once!

Once again, thank you and please tell a friend about us!
Sincerely, $config{'sitename'}
";

$SellerReserveMet = "
Greetings $firstbid[1]!

This Auction Is Now Closed:

Item number : $item
Title : $title
Category : $category{$key}
URL Here : http://$config{'scripturl'}/cgi-bin/openauction.cgi\?category=$key&item=$item


The high bid was \$$lastbid[2] (Your reserve was: \$$reserve).

Please contact the high bidder to make any necessary arrangements:

$lastbid[4]
$lastbid[5]
$lastbid[6]
$lastbid[7]
$lastbid[1]

Once again, thank you and please tell a friend about us!
Sincerely, $config{'sitename'}

";

$SellerNoBids = "
Greetings $firstbid[1]!

This Auction Is Now Closed:

Item number : $item
Title : $title
Category : $category{$key}
URL Here : http://$config{'scripturl'}/cgi-bin/openauction.cgi\?category=$key&item=$item

Your reserve was: \$$reserve.

Sorry, no bids were placed on your auction. 

Feel free to repost your auction by following this link: 

http://$config{'scripturl'}/cgi-bin/openauction.cgi\?category=$key&item=$item

Once again, thank you and please tell a friend about us!
Sincerely, $config{'sitename'}

";

$SellerReserveNotMet = "
Greetings $firstbid[1]!

This Auction Is Now Closed

Item number : $item
Title : $title
Category : $category{$key}
URL Here : http://$config{'scripturl'}/cgi-bin/openauction.cgi\?category=$key&item=$item


The high bid was \$$lastbid[2] (Your reserve was: \$$reserve).

YOUR RESERVE PRICE WAS NOT MET!

You may want to contact the high bidder to negotiate a sale:

$lastbid[4]
$lastbid[5]
$lastbid[6]
$lastbid[7]
$lastbid[1]

Feel free to repost your auction by following this link: 

http://$config{'scripturl'}/cgi-bin/openauction.cgi\?category=$key&item=$item

Once again, thank you and please tell a friend about us!
Sincerely, $config{'sitename'}

";

$RepostMessage = "
Hello $firstbid[0], 
Thank you for using nTiq Online Auction! 
The following item has been relisted because it didn't sell:

The item information re-posted is as follows : 
Item number : $new
Title : $title
Category : $category{$key}
URL Here : http://$config{'scripturl'}/cgi-bin/openauction.cgi\?category=$key&item=$item

Once again, thank you and please tell a friend about us!
Sincerely, $config{'sitename'}
"; 

#### End Define Messages###############################################

if ($doit == 1) {
&sendemail($firstbid[1],'Relist of Auction', 'nobody', $mailserver, $RepostMessage); 
} 
else {
	umask(000);  # UNIX file permission junk
	mkdir("$config{'basepath'}$config{'closedir'}", 0777) unless (-d "$config{'basepath'}$config{'closedir'}");		
	&CloseItem("$key", "$item");
	if (($lastbid[2] >= $reserve) && ($firstbid[0] ne $lastbid[0]))  {
		&sendemail($lastbid[1], $config{'admin_address'}, "Auction Close: $title",$BidderReserveMet );
		&sendemail($firstbid[1], $config{'admin_address'}, "Auction Close: $title", $SellerReserveMet);
	}
	if (($lastbid[2] < $reserve) && ($firstbid[0] ne $lastbid[0]))  {
		&sendemail($lastbid[1], $config{'admin_address'}, "Auction Close: $title",$BidderReserveNotMet );
		&sendemail($firstbid[1], $config{'admin_address'}, "Auction Close: $title", $SellerReserveNotMet);
	}
	if ($firstbid[0] eq $lastbid[0])  {
		&sendemail($firstbid[1], $config{'admin_address'}, "Auction Close: $title", $SellerNoBids);
	}
}
}
}
}
1;
